% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDR.R
\name{FDR}
\alias{FDR}
\alias{pvalue.FDR}
\title{False Discorvery Rate (FDR)}
\usage{
FDR(pvalues = NULL, alpha = 0.95, dep = 1)

pvalue.FDR(pvalues = NULL, dep = 1)
}
\arguments{
\item{pvalues}{Vector of p-values}

\item{alpha}{Alpha value (level of significance).}

\item{dep}{Parameter dependence test. By default \code{dep = 1}, direct
dependence between tests.}
}
\value{
Return:
\itemize{
\item \code{out.FDR=TRUE}: If there are significative differences.
\item \code{pv.FDR}: p-value for False Discovery Rate test.
}
}
\description{
Compute the False Discovery Rate for a vector of p-values and alpha value.
}
\details{
\code{FDR} method is used for multiple hypothesis testing to correct
problems of multiple contrasts.\cr If \code{dep = 1}, the tests are
positively correlated, for example when many tests are the same contrast.
\cr If \code{dep < 1} the tests are negatively correlated.
}
\examples{
 p=seq(1:50)/1000
 FDR(p)
 pvalue.FDR(p)
 FDR(p,alpha=0.9999)
 FDR(p,alpha=0.9)
 FDR(p,alpha=0.9,dep=-1)
}
\references{
Benjamini, Y., Yekutieli, D. (2001). \emph{The control of the
false discovery rate in multiple testing under dependency}. Annals of
Statistics. 29 (4): 1165-1188. DOI:10.1214/aos/1013699998.
}
\seealso{
Function used in \code{\link{fanova.RPm}}
}
\author{
Febrero-Bande, M.  and Oviedo de la Fuente, M.
}
