% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Outliers.fdata.R
\name{Outliers.fdata}
\alias{Outliers.fdata}
\alias{outliers.depth.pond}
\alias{outliers.depth.trim}
\alias{outliers.thres.lrt}
\alias{outliers.lrt}
\alias{quantile.outliers.trim}
\alias{quantile.outliers.pond}
\title{outliers for functional dataset}
\usage{
outliers.depth.pond(
  fdataobj,
  nb = 200,
  smo = 0.05,
  quan = 0.5,
  dfunc = depth.mode,
  ...
)

outliers.depth.trim(
  fdataobj,
  nb = 200,
  smo = 0.05,
  trim = 0.01,
  quan = 0.5,
  dfunc = depth.mode,
  ...
)

outliers.lrt(fdataobj, nb = 200, smo = 0.05, trim = 0.1, ...)

outliers.thres.lrt(fdataobj, nb = 200, smo = 0.05, trim = 0.1, ...)
}
\arguments{
\item{fdataobj}{\code{\link{fdata}} class object.}

\item{nb}{The number of bootstrap samples.}

\item{smo}{The smoothing parameter for the bootstrap samples.}

\item{quan}{Quantile to determine the cutoff from the Bootstrap procedure (by default=0.5)}

\item{dfunc}{Type of depth measure, by default \code{depth.mode}.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{trim}{The alpha of the trimming.}
}
\value{
\item{\code{outliers}}{ Indexes of functional outlier.}
 \item{\code{dep.out}}{  Depth value of functional outlier.}
 \item{\code{dep.out}}{  Iteration in which the  functional outlier is detected.}
 \item{\code{quantile}}{  Threshold for outlier detection.}
 \item{\code{dep}}{  Depth value of functional data.}
}
\description{
Procedure for detecting funcitonal outliers.
}
\details{
Outlier detection in functional data by likelihood ratio test (\code{outliers.lrt}). The threshold for outlier detection is given by the 
  \code{outliers.thres.lrt}.
 Outlier detection in functional data by depth measures: 
 
 \itemize{
   \item \code{outliers.depth.pond}: function weights the data according to depth.    
   \item \code{outliers.depth.trim}: function uses trimmed data.
 }
 \code{quantile_outliers_pond} and \code{quantile_outliers_trim} functions provides
  the quantiles of the bootstrap samples for functional outlier detection by, 
  respectively, weigthed and trimmed procedures. Bootstrap smoothing function 
  (\code{\link{fdata.bootstrap}} with \code{nb} resamples) is applied to these 
  weighted or trimmed data. If \code{smo=0} smoothed bootstrap is not performed.
  The function returns a vector of size \code{1}x\code{nb} with bootstrap replicas of the quantile.
}
\examples{
\dontrun{
data(aemet)
nb=20 # Time consuming
out.trim<-outliers.depth.trim(aemet$temp,dfunc=depth.FM,nb=nb)
plot(aemet$temp,col=1,lty=1)
lines(aemet$temp[out.trim[[1]]],col=2)
}
}
\references{
Cuevas A, Febrero M, Fraiman R. 2006.  \emph{On the use of bootstrap for estimating functions with functional data}. Computational Statistics and Data Analysis 51: 1063-1074.
  
Febrero-Bande, M., Galeano, P., and Gonzalez-Manteiga, W. (2008).  
\emph{Outlier detection in functional data by depth measures with application to identify abnormal NOx levels}. Environmetrics 19, 4, 331--345. 

Febrero-Bande, M., Galeano, P. and Gonzalez-Manteiga, W.	 (2007). \emph{A functional analysis of NOx levels: location and scale estimation and outlier detection}. Computational Statistics 22, 3, 411-427.

Febrero-Bande,  M., Oviedo de la Fuente, M. (2012).  \emph{Statistical Computing in Functional Data Analysis: The R Package fda.usc.}
Journal of Statistical Software, 51(4), 1-28. \url{https://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also: \code{\link{fdata.bootstrap}}, \code{\link{Depth}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente \email{manuel.oviedo@udc.es}
}
\keyword{outliers}
