% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-runs-test.R
\name{plot_runs_test}
\alias{plot_runs_test}
\title{Plot Runs Test Results}
\usage{
plot_runs_test(results, ...)
}
\arguments{
\item{results}{A list of runs test results generated by \code{\link[=eda_runs_test]{eda_runs_test()}}.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; a plot containing:
\itemize{
\item Black points for the residual at each year.
\item A red dashed horizontal line at \eqn{y = 0}.
\item A text annotation “Runs p-value: X.XXX” in the plot area.
}
}
\description{
Generates a residual plot of Sen's estimator applied to annual maximum series
data (or the variability of the data) with a horizontal dashed line at
zero and an annotation indicating the p-value of the Runs test.
}
\examples{
# Initialize data and years
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)

# Generate the runs test plot 
sens_trend <- eda_sens_trend(data, years)
results <- eda_runs_test(sens_trend$residuals, years)
plot_runs_test(results)

}
\seealso{
\code{\link[=eda_runs_test]{eda_runs_test()}}
}
