% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig.R
\name{fig}
\alias{fig}
\title{Parse Image to a Fig}
\usage{
fig(
  path,
  aspect.ratio = "default",
  link_dim = TRUE,
  b_col = NULL,
  b_size = 1,
  b_pos = "offset",
  b_margin = ggplot2::margin(4, 4, 4, 4)
)
}
\arguments{
\item{path}{Path to image file.}

\item{aspect.ratio}{Manually override the image's aspect ratio or set "free"
to allow fig to be resized by patchwork.}

\item{link_dim}{Logical, whether to lock the dimensions & aspect.ratio of the
aligned plots to that of this fig.}

\item{b_col}{Colour of the border line.}

\item{b_size}{Size of the border line.}

\item{b_pos}{Whether the border is 'offset' (expands out from figure) or
'inset' and expands inwards, partially covering up the figure.}

\item{b_margin}{Margin around the fig. Use \code{ggplot2::margin()}}
}
\value{
\code{\{ggplot2\}} object
}
\description{
Read image and convert to ggplot object, for use with other ggplot objects
when assembling with the \code{{patchwork}} package. Can also specify a
border.
}
\examples{

library(figpatch)
library(ggplot2)

# Attach the fig image file
image <- system.file("extdata", "fig.png", package = "figpatch", mustWork = TRUE)

# Read in the image as a 'fig'
img <- fig(image)

img
}
