# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Unmix sediment mixtures using constrained optimization and linear variability propagation (LVP)
#'
#' @param sources Data frame containing sediment source samples
#' @param mixtures Data frame containing mixture samples
#' @param variability Integer specifying the type of variability to calculate.
#'   Possible values are 0 for Standard Deviation or 1 for Standard Error of the Mean.
#' @param iter Iterations in the variability analysis.
#' @param resolution Integer specifying the number of samples used in each hypercube dimension.
#' @param seed Seed for the random number generator
#' @return Data frame containing the relative contribution of the sediment sources for each sediment mixture and iterations
unmix_c_lvp <- function(sources, mixtures, variability, iter = 100L, resolution = 100L, seed = 69512L) {
    .Call('_fingerPro_unmix_c_lvp', PACKAGE = 'fingerPro', sources, mixtures, variability, iter, resolution, seed)
}

#' Unmix sediment mixtures using constrained optimization and classical variability propagation
#'
#' @param sources Data frame containing sediment source samples
#' @param mixtures Data frame containing mixture samples
#' @param variability Integer specifying the type of variability to calculate.
#'   Possible values are 0 for Standard Deviation or 1 for Standard Error of the Mean.
#' @param iter Iterations in the variability analysis.
#' @param resolution Integer specifying the number of samples used in each hypercube dimension.
#' @param seed Seed for the random number generator
#' @return Data frame containing the relative contribution of the sediment sources for each sediment mixture and iterations
unmix_c <- function(sources, mixtures, variability, iter = 100L, resolution = 100L, seed = 69512L) {
    .Call('_fingerPro_unmix_c', PACKAGE = 'fingerPro', sources, mixtures, variability, iter, resolution, seed)
}

#' least_squares_c
#'
#' @param sources Data frame containing sediment source samples
#' @param mixtures Data frame containing mixture samples
#' @param iter Iterations in the variability analysis.
#' @param seed Seed for the random number generator
#' @return Data frame containing the relative contribution solved by the least squares method
least_squares_c <- function(sources, mixtures, iter = 100L, seed = 69512L) {
    .Call('_fingerPro_least_squares_c', PACKAGE = 'fingerPro', sources, mixtures, iter, seed)
}

#' triangles_random_c
#'
#' @param sources Data frame containing sediment source samples
#' @param mixtures Data frame containing mixture samples
#' @param tracer Tracer in which implement the function
#' @param iter Iterations in the variability analysis.
#' @param seed Seed for the random number generator
#' @return List of data frames containing all the possible prediction for each tracer
triangles_random_c <- function(sources, mixtures, tracer = 0L, iter = 100L, seed = 69512L) {
    .Call('_fingerPro_triangles_random_c', PACKAGE = 'fingerPro', sources, mixtures, tracer, iter, seed)
}

#' triangles_virtual_c
#'
#' @param sources Data frame containing sediment source samples
#' @param mixtures Data frame containing mixture samples
#' @param tracer Tracer in which implement the function
#' @param iter Iterations in the variability analysis.
#' @param seed Seed for the random number generator
#' @return List of data frames containing all the possible prediction for each tracer inside the dataset
triangles_virtual_c <- function(sources, mixtures, tracer = 0L, iter = 100L, seed = 69512L) {
    .Call('_fingerPro_triangles_virtual_c', PACKAGE = 'fingerPro', sources, mixtures, tracer, iter, seed)
}

