% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_plot.R
\name{box_plot}
\alias{box_plot}
\title{Box and whiskers plot for sediment tracers}
\usage{
box_plot(data, tracers = NULL, ncol = 3, colors = NULL)
}
\arguments{
\item{data}{A data frame containing sediment source and mixture data. Users should ensure their data is in a valid format by using the check_database() function before running this function.}

\item{tracers}{A numeric vector specifying the column indices of the tracers to be plotted. The index 1 corresponds to the first tracer column after the sample ID and group columns. If NULL (the default), plots will be generated for all tracer columns.}

\item{ncol}{An integer specifying the number of charts to display per row in the final plot layout.}

\item{colors}{A character vector of colors to use for the box plots. The colors are applied sequentially to each group (sources and mixture).}
}
\description{
This function creates a series of box and whisker plots to visualize the distribution and variability of individual tracers within a dataset. It is designed to work with sediment source and mixture data, automatically adapting to averaged or raw data formats.
}
\details{
This function is a wrapper for ggplot2 that automates the creation of a series of box plots, one for each tracer. The function first checks if the input data is averaged, and if so, converts it to a virtual raw dataset using the raw_dataset() function to enable the box plot visualization.

Each plot displays the distribution of a single tracer, with different groups (sources and mixtures) represented by separate box plots. In addition to the standard five-number summary (median, hinges, and whiskers), the function also overlays the sample count and the mean value for each group, providing a more detailed summary of the data.

The final output is a multi-panel plot arranged in a grid, with an optional legend depending on the input data.
}
