% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_concept_labels.R
\name{get_concept_labels}
\alias{get_concept_labels}
\title{Get labels for a specific concept from the Finto Skosmos API and return as a tibble}
\usage{
get_concept_labels(uri, lang = NULL)
}
\arguments{
\item{uri}{The URI of the concept to retrieve labels for.}

\item{lang}{The language of labels to retrieve, e.g., "en" or "fi". Optional.}
}
\value{
A tibble containing the URI, preferred label (\code{prefLabel}), alternative labels (\code{altLabel}), and hidden labels (\code{hiddenLabel}) for the concept.
}
\description{
Get labels for a specific concept from the Finto Skosmos API and return as a tibble
}
\examples{
labeles <- get_concept_labels(uri = "http://www.yso.fi/onto/koko/p91024",
lang = "fi")
print(labeles)
}
