% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_script.R
\name{run_script}
\alias{run_script}
\title{Predict MS^2 fragment spectra from SMILES code.}
\usage{
run_script(
  x = data.frame(Name = "Example_0", SMILES = "CC1=CC(=O)OC2=CC(OS(O)(=O)=O)=CC=C12",
    Precursor_type = "[M-H]-", CE = 17, Instrument_type = "HCD"),
  min_prob = 0.001,
  annotation = FALSE,
  fiora_script = NULL,
  fmt = c("list", "df", "Spectra", "file_only"),
  file_out = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A data frame containing columns Name (compound names), SMILES (SMILES
code of the compounds, Precursor_type (currently "[M-H]-" or "[M+H]+"), CE
(Collision energy) and Instrument_type (i.e. HCD).}

\item{min_prob}{Minimum peak probability to be recorded in the spectrum.}

\item{annotation}{Return SMILES for fragments if TRUE.}

\item{fiora_script}{Path to python script fiora-predict.}

\item{fmt}{Set fmt to 'df' to simplify the return value to a data frame (named
list otherwise). You may also use 'file_only' to omit output to the console
if you specify a valid path in 'file_out'.}

\item{file_out}{Specify a path to a file to store the FIORA result permanently.}

\item{verbose}{Set to FALSE to omit messages.}
}
\value{
A list with the fiora results for the specified compound(s).
}
\description{
A wrapper around the python script `fiora-predict` using the
    fiora open source model to generate a MS^2 spectra for a compound with
    known SMILES code.
}
\details{
This wrapper will generate a fiora ready input file (csv-format)
    based on the user parameters which is stored as a temp file. It will
    ensure that the current version of the fiora package is installed in a
    respective python environment. It will use `system2()` to run the python
    script `fiora-predict` and import its result back into R using function
    `read_fiora()`.
    You can try different installed version of `fiora` by providing the path
    the the script explicitly.
}
\examples{
\dontrun{
  # !!! running this example will install the python module `fiora`
  td <- fioRa::test_data
  x <- setNames(data.frame(
    t(sapply(td[2:11], function(x) { strsplit(x, ",")[[1]] }))),
    strsplit(td[1], ",")[[1]]
   )
  foo <- run_script(x = x)
  foo[[1]][["spec"]]
  # modify parameters
  run_script(x = x[1,,drop=FALSE], min_prob = 0.05)

  # you may also return a Spectra object
  run_script(x = x[1,,drop=FALSE], min_prob = 0.05, annotation = TRUE, fmt = "Spectra")

  # use a different fiora environment/model
  s_pth <- "c:/Users/jlisec/AppData/Local/r-miniconda/envs/fiora-0.1.0/Scripts/fiora-predict"

  # this setup will be used internally
  fioRa:::find_fiora_predict_paths(default_path = dirname(s_pth), script_name = basename(s_pth))

  # run the script
  foo2 <- run_script(x = x, fiora_script = s_pth)

  foo2[[1]][["spec"]]

  for (i in 1:length(foo)) {
    cat("\n")
    print(names(foo)[i])#'
    print(foo[[i]][["spec"]])
    print(foo2[[i]][["spec"]])
  }

}

}
