% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-betting-odds.R
\name{fetch_betting_odds_footywire}
\alias{fetch_betting_odds_footywire}
\title{Fetch AFL match betting odds from https://www.footywire.com}
\usage{
fetch_betting_odds_footywire(
  start_season = "2010",
  end_season = lubridate::year(Sys.Date())
)
}
\arguments{
\item{start_season}{First season to return, in yyyy format. Earliest season with data available is 2010.}

\item{end_season}{Last season to return, in yyyy format}
}
\value{
Returns a data frame containing betting odds and basic match info
}
\description{
\code{fetch_betting_odds_footywire} returns a data frame containing betting odds and basic match info for Men's AFL matches.
}
\details{
The data frame contains the home and away team as well as venue.
}
\examples{
\dontrun{
fetch_betting_odds_footywire(2012, 2018)
}
}
