% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitstats.R
\name{print.fixest_fitstat}
\alias{print.fixest_fitstat}
\title{Print method for fit statistics of fixest estimations}
\usage{
\method{print}{fixest_fitstat}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An object resulting from the \code{\link{fitstat}} function.}

\item{na.rm}{Logical, default is \code{FALSE}. If \code{TRUE}, the statistics that are missing
are not displayed.}

\item{...}{Not currently used.}
}
\description{
Displays a brief summary of selected fit statistics from the function \code{\link{fitstat}}.
}
\examples{

data(trade)
gravity = feols(log(Euros) ~ log(dist_km) | Destination + Origin, trade)

# Extracting the 'working' number of observations used to compute the pvalues
fitstat(gravity, "g", simplify = TRUE)

# Some fit statistics
fitstat(gravity, ~ rmse + r2 + wald + wf)

# You can use them in etable
etable(gravity, fitstat = ~ rmse + r2 + wald + wf)

# For wald and wf, you could show the pvalue instead:
etable(gravity, fitstat = ~ rmse + r2 + wald.p + wf.p)

# Now let's display some statistics that are not built-in
# => we use fitstat_register to create them

# We need: a) type name, b) the function to be applied
#          c) (optional) an alias

fitstat_register("tstand", function(x) tstat(x, se = "stand")[1], "t-stat (regular)")
fitstat_register("thc", function(x) tstat(x, se = "heter")[1], "t-stat (HC1)")
fitstat_register("t1w", function(x) tstat(x, se = "clus")[1], "t-stat (clustered)")
fitstat_register("t2w", function(x) tstat(x, se = "twow")[1], "t-stat (2-way)")

# Now we can use these keywords in fitstat:
etable(gravity, fitstat = ~ . + tstand + thc + t1w + t2w)

# Note that the custom stats we created are can easily lead
# to errors, but that's another story!


}
