% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_profile.R
\name{plot.light_profile}
\alias{plot.light_profile}
\title{Visualize Profiles, e.g. Partial Dependence}
\usage{
\method{plot}{light_profile}(
  x,
  swap_dim = FALSE,
  facet_scales = "free_x",
  rotate_x = x$type != "partial dependence",
  show_points = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class "light_profile".}

\item{swap_dim}{If multiflashlight and one "by" variable or
single flashlight with two "by" variables, swap the role of dodge/fill variable
and facet variable. If multiflashlight or one "by" variable,
use facets instead of colors.}

\item{facet_scales}{Scales argument passed to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees?}

\item{show_points}{Should points be added to the line (default is \code{TRUE}).}

\item{...}{Further arguments passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} or
\code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}.}
}
\value{
An object of class "ggplot".
}
\description{
Minimal visualization of an object of class "light_profile".
The object returned is of class "ggplot" and can be further customized.
}
\details{
Either lines and points are plotted (if stats = "mean") or quartile boxes.
If there is a "by" variable or a multiflashlight, this first dimension
is represented by color (or if \code{swap_dim = TRUE} by facets).
If there are two "by" variables or a multiflashlight with one "by" variable,
the first "by" variable is visualized as color, while the second one
or the multiflashlight is shown via facet (change with \code{swap_dim}).
}
\seealso{
\code{\link[=light_profile]{light_profile()}}, \code{\link[=plot.light_effects]{plot.light_effects()}}
}
