% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_quad}
\alias{fn_quad}
\title{Quadratic function}
\usage{
fn_quad(t, a, b, c)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{a}{The quadratic coefficient (curvature).}

\item{b}{The linear coefficient (slope at the origin).}

\item{c}{The intercept (function value when \code{t = 0}).}
}
\value{
A numeric vector of the same length as \code{t}, representing the
quadratic function values.
}
\description{
A standard quadratic function of the form \code{f(t) = a * t^2 + b * t + c}, where
\code{a} controls curvature, \code{b} is the linear coefficient, and \code{c} is the intercept.
}
\details{
\if{html}{
\deqn{
f(t; a, b, c) = a \cdot t^2 + b \cdot t + c
}
}

This function represents a second-degree polynomial. The sign of \code{a}
determines whether the parabola opens upward (\code{a > 0}) or downward (\code{a < 0}).
}
\examples{
library(flexFitR)
plot_fn(fn = "fn_quad", params = c(a = 1, b = 10, c = 5))
}
