% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-plot-grid.R
\name{DoU_plot_grid}
\alias{DoU_plot_grid}
\title{Plot the grid cell classification}
\usage{
DoU_plot_grid(
  classification,
  extent = NULL,
  level1 = TRUE,
  palette = NULL,
  labels = NULL,
  title = NULL,
  scalebar = FALSE,
  filename = NULL
)
}
\arguments{
\item{classification}{SpatRaster / character. A SpatRaster with the grid cell classification or the path to the grid cell classification file}

\item{extent}{SpatExtent. If not \code{NULL}, the grid classification will be cropped to the provided extent before plotting}

\item{level1}{logical. Whether the grid is classified according to level 1 of the Degree of Urbanisation (\code{TRUE}), or level 2 of the Degree of Urbanisation (\code{FALSE}).}

\item{palette}{named vector with the color palette used to plot the grid cell classification. If \code{NULL}, the standard color palette of the GHSL is used (see \code{GHSL_palette()}).}

\item{labels}{vector with the labels used in the legend. If \code{NULL}, the standard labels of the GHSL are used (see \code{GHSL_labels()}).}

\item{title}{character. Title of the plot.t}

\item{scalebar}{logical. Whether to add a scale bar to the plot.}

\item{filename}{character. Path to the location to save the plot}
}
\value{
ggplot object
}
\description{
The function can be used to plot the results of the grid cell classification of the Degree of Urbanisation. The implementation relies upon the function \code{tidyterra::geom_spatraster()}. By default, the standard color scheme of the Global Human Settlement Layer (GHSL) is used (see \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023}), but this can be altered by the \code{palette} argument.

Note that the function is computational quite heavy for large spatial extents (regional or global scale). It is advised to use the \code{extent} argument to plot only a selection of the grid classification.
}
\examples{
classification <- DoU_classify_grid(DoU_load_grid_data_belgium())

# plot with standard color scheme
DoU_plot_grid(classification)

# use custom palette and labels
DoU_plot_grid(classification,
  palette = c("3" = "#e16c72", "2" = "#fac66c", "1" = "#97c197", "0" = "#acd3df"),
  labels = c("UC", "UCL", "RUR", "WAT")
)
}
