% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-grid-urban-centres.R
\name{classify_grid_urban_centres}
\alias{classify_grid_urban_centres}
\title{Create the DEGURBA grid cell classification of urban centres}
\usage{
classify_grid_urban_centres(
  data,
  density_threshold = 1500,
  size_threshold = 50000,
  contiguity_rule = 4,
  built_criterium = TRUE,
  built_threshold = 0.2,
  smooth_pop = FALSE,
  smooth_pop_window = 5,
  gap_fill = TRUE,
  max_gap = 15,
  smooth_edge = TRUE,
  smooth_edge_fun = "majority_rule_R2023A",
  value = 3
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}}

\item{density_threshold}{numeric. Minimum population density per permanent land of a cell required to belong to an urban centre}

\item{size_threshold}{numeric. Minimum total population size required for an urban centre}

\item{contiguity_rule}{integer. Which cells are considered adjacent: \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}

\item{built_criterium}{logical. Whether to use the additional built-up area criterium (see details). If \code{TRUE}, not only cells that meet the population density requirement will be considered when delineating urban centres, but also cells with a built-up area per permanent land above the \code{built_threshold}}

\item{built_threshold}{numeric. Additional built-up area threshold. A value between \code{0} and \code{1}, representing the minimum built-up area per permanent land. Ignored when \code{built_criterium} is \code{FALSE}.}

\item{smooth_pop}{logical. Whether to smooth the population grid before delineating urban centres. If \code{TRUE}, the population grid will be smoothed with a moving average of window size \code{smooth_pop_window}.}

\item{smooth_pop_window}{integer. Size of the moving window used to smooth the population grid before delineating urban centres. Ignored when \code{smooth_pop} is \code{FALSE}.}

\item{gap_fill}{logical. Whether to perform gap filling. If \code{TRUE}, gaps in urban centres smaller than \code{max_gap} are filled.}

\item{max_gap}{integer. Gaps with an area smaller than this threshold in urban centres will be filled (unit is km²). Ignored when \code{gap_fill} is \code{FALSE}.}

\item{smooth_edge}{logical. Whether to perform edge smoothing. If \code{TRUE}, edges of urban centres are smoothed with the function \code{smooth_edge_fun}.}

\item{smooth_edge_fun}{character / function. Function used to smooth the edges of urban centres. Ignored when \code{smooth_edge} is \code{FALSE}. Possible values are:
\itemize{
\item \code{"majority_rule_R2022A"} to use the edge smoothing algorithm in GHSL Data Package 2022 (see details)
\item \code{"majority_rule_R2023A"} to use the edge smoothing algorithm in GHSL Data Package 2023 (see details)
\item a custom function with a signature similar as \code{\link[=apply_majority_rule]{apply_majority_rule()}}.
}}

\item{value}{integer. Value assigned to urban centres in the resulting grid}
}
\value{
SpatRaster with the grid cell classification of urban centres
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{classify_grid_urban_centres()} has been renamed to \code{DoU_classify_grid_urban_centres()} to create a more consistent API and to better indicate that this function is specifically designed to classify urban centres in the context of the DEGURBA classification.
}
\keyword{internal}
