% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-get-optimal-builtup.R
\name{get_optimal_builtup}
\alias{get_optimal_builtup}
\title{Preprocess the data for the DEGURBA spatial units classification}
\usage{
get_optimal_builtup(
  data,
  density_threshold = 1500,
  size_threshold = 5000,
  directions = 4
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}. Ideally, it contains data on a global scale.}

\item{density_threshold}{numeric. Minimum population density per permanent land}

\item{size_threshold}{numeric. Minimum population size}

\item{directions}{integer. Which cells are considered adjacent: \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}
}
\value{
optimal built-up area threshold
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{get_optimal_builtup()} has been renamed to \code{DoU_get_optimal_builtup()} to create a more consistent API and to better indicate that this function is specifically designed for detecting the optimal builtup threshold in the context of the DEGURBA classification with \code{DoU_classify_units()}.
}
\keyword{internal}
