% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-grid.R
\name{classify_grid}
\alias{classify_grid}
\title{Create the DEGURBA grid cell classification}
\usage{
classify_grid(
  data,
  level1 = TRUE,
  parameters = NULL,
  values = NULL,
  regions = FALSE,
  filename = NULL
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}}

\item{level1}{logical. Whether to classify the grid according to first hierarchical level (\code{TRUE}) or the second hierarchical level (\code{FALSE}). For more details, see section "Classification rules" below.}

\item{parameters}{named list with the parameters to adapt the standard specifications in the Degree of Urbanisation classification. For more details, see section "Custom specifications" below.}

\item{values}{vector with the values assigned to the different classes in the resulting classification:
\itemize{
\item If \code{level1=TRUE}: the vector should contain the values for (1) urban centres, (2) urban clusters, (3) rural grid cells and (4) water cells.
\item If \code{level1=FALSE}: the vector should contain the values for (1) urban centres, (2) dense urban clusters, (3) semi-dense urban clusters, (4) suburban or peri-urban cells, (5) rural clusters, (6) low density rural cells, (7) very low density rural cells and (8) water cells.
}}

\item{regions}{logical. Whether to execute the classification in the memory-efficient pre-defined regions. For more details, see section "Regions" below (Note that this requires a large amount of memory).}

\item{filename}{character. Output filename (with extension \code{.tif}). The grid classification together with a metadata file (in JSON format) will be saved if \code{filename} is not \code{NULL}.}
}
\value{
SpatRaster with the grid cell classification
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{classify_grid()} has been renamed to \code{DoU_classify_grid()} to create a more consistent API and to better indicate that this function is specifically designed for the DEGURBA grid classification.
}
\keyword{internal}
