% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-plot-grid.R
\name{plot_grid}
\alias{plot_grid}
\title{Plot the grid cell classification}
\usage{
plot_grid(
  classification,
  extent = NULL,
  level1 = TRUE,
  palette = NULL,
  labels = NULL,
  title = NULL,
  scalebar = FALSE,
  filename = NULL
)
}
\arguments{
\item{classification}{SpatRaster / character. A SpatRaster with the grid cell classification or the path to the grid cell classification file}

\item{extent}{SpatExtent. If not \code{NULL}, the grid classification will be cropped to the provided extent before plotting}

\item{level1}{logical. Whether the grid is classified according to level 1 of the Degree of Urbanisation (\code{TRUE}), or level 2 of the Degree of Urbanisation (\code{FALSE}).}

\item{palette}{named vector with the color palette used to plot the grid cell classification. If \code{NULL}, the standard color palette of the GHSL is used (see \code{GHSL_palette()}).}

\item{labels}{vector with the labels used in the legend. If \code{NULL}, the standard labels of the GHSL are used (see \code{GHSL_labels()}).}

\item{title}{character. Title of the plot.t}

\item{scalebar}{logical. Whether to add a scale bar to the plot.}

\item{filename}{character. Path to the location to save the plot}
}
\value{
ggplot object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{plot_grid()}  has been renamed to \code{DoU_plot_grid()} to create a more consistent API and to better indicate that this function is specifically designed for plotting the DEGURBA classification generated with \code{DoU_classify_grid()}.
}
\keyword{internal}
