% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_airport_movement.R
\name{download_airport_movement_data}
\alias{download_airport_movement_data}
\title{Download and read ANAC airport movement data}
\usage{
download_airport_movement_data(
  file_url = parent.frame()$file_url,
  showProgress = parent.frame()$showProgress,
  cache = parent.frame()$cache
)
}
\arguments{
\item{file_url}{String. A url passed from \code{\link{read_airport_movements}}.}

\item{showProgress}{Logical, passed from \code{\link{read_airport_movements}}}

\item{cache}{Logical, passed from \code{\link{read_airport_movements}}}
}
\value{
A \verb{"data.table" "data.frame"} object
}
\description{
Download and read ANAC airport movement data
}
\examples{
\dontrun{ if (interactive()) {
# Generate url
file_url <- get_airport_movements_url(year=2020, month=11)

# download data
a <- download_airport_movement_data(file_url=file_url, showProgress=TRUE)
}}
}
\keyword{internal}
