% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_flipscores.R
\name{anova.flipscores}
\alias{anova.flipscores}
\title{anova.flipscores}
\usage{
\method{anova}{flipscores}(object, model1 = NULL, score_type = NULL, n_flips = 5000, id = NULL, ...)
}
\arguments{
\item{object}{(the object) \code{glm} (or \code{flipscores}) object with the model under the null hypothesis (i.e. the covariates, the nuisance parameters).}

\item{model1}{a \code{glm} (or \code{flipscores}) or a \code{matrix} (or \code{vector}). If it is a \code{glm} object, it has the model under the alternative hypothesis. The variables in \code{model1} are the same variables in \code{object} plus one or more variables to be tested.  Alternatively, if
\code{model1} is a \code{matrix}, it contains the tested variables column-wise.}

\item{score_type}{The type of score that is computed. It can be "orthogonalized", "effective" or "basic".
Default is "orthogonalized". "effective" and "orthogonalized" take into account the nuisance estimation. The default is \code{NULL}, in this case the value is taken from \code{object}.}

\item{n_flips}{The number of random flips of the score contributions.
When \code{n_flips} is equal or larger than the maximum number of possible flips (i.e. n^2), all possible flips are performed. 
Default is 5000.}

\item{id}{a \code{vector} identifying the clustered observations. If \code{NULL} (default) observations are assumed to be independent. NOTE: if \code{object} is a \code{flipscores} and \code{model$flip_param_call$id} is not \code{NULL}, this is considered in the inference.}

\item{...}{other parameters allowed in \code{stats::anova}.}
}
\description{
This is the \code{anova} method for \code{flipscores} object. Remark: it performs type III deviance decomposition as in \code{car::Anova}.
}
\examples{
set.seed(1)
dt=data.frame(X=scale(rnorm(50)),
   Z=factor(rep(LETTERS[1:3],length.out=50)))
dt$Y=rpois(n=nrow(dt),lambda=exp(dt$X*(dt$Z=="C")))
mod0=flipscores(Y~Z+X,data=dt,family="poisson")
summary(mod0)
anova(mod0)

mod1=flipscores(Y~Z*X,data=dt,family="poisson")
summary(mod1)
anova(mod0,model1 = mod1)

}
