% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flipscores.R
\name{flipscores}
\alias{flipscores}
\title{Robust testing in GLMs, by sign-flipping score contributions}
\usage{
flipscores(formula, family, data, score_type = "standardized",
n_flips = 5000, alternative = "two.sided", id = NULL,
seed = NULL, to_be_tested = NULL, flips = NULL,
precompute_flips=TRUE, ...)
}
\arguments{
\item{formula}{see \code{glm} function. It can also be a model (usually generated by a call to \code{glm}); in this case, any other glm-related parameter (e.g. \code{family, data, etc.}) are discarded, the function will make use of the ones used to generate the model.
(i.e. \code{formula}, \code{family}, \code{data}, etc) are not considered.  It is \code{NULL} by default (i.e. not used).}

\item{family}{see \code{glm} function.}

\item{data}{see \code{glm} function.}

\item{score_type}{The type of score that is computed. It can be "standardized" "orthogonalized", "effective" or "basic".
Both "orthogonalized" and "effective" take into account the nuisance estimation and they provide the same
test statistic. In case of small samples "effective score" might have a slight anti-conservative behaviour.
"standardized effective score" gives a solution for this issue.
"orthogonalized" has a similar intent, note however that in case of a big model matrix, it may be slow.}

\item{n_flips}{The number of random flips of the score contributions. Overwritten with the \code{nrow(flips)} when \code{flips} is not \code{NULL} (see parameter \code{flips} for more details).
When \code{n_flips} is equal or larger than the maximum number of possible flips (i.e. n^2), all possible flips are performed.}

\item{alternative}{It can be "greater", "less" or "two.sided" (default)}

\item{id}{a \code{vector} identifying the clustered observations. If \code{NULL} (default) observations are assumed to be independent. If \code{id} is not \code{NULL}, only \code{score_type=="effective"} is allowed, yet.}

\item{seed}{\code{NULL} by default.}

\item{to_be_tested}{vector of indices or names of coefficients of the glm model to be tested (it is faster than computing every scores and p-values of course).}

\item{flips}{matrix fo +1 or -1, the matrix has \code{n_flips} rows and n (number of observations) columns}

\item{precompute_flips}{\code{TRUE} by default. Overwritten if \code{flips} is not \code{NULL}. If \code{FALSE} the matrix of flips is not computed and the flips are made 'on-the-fly' before computing the test statistics; it may be usefull when \code{flips} is very large (see parameter \code{flips} for more details).}

\item{...}{see \code{glm} function.}
}
\value{
an object of class \code{flipscores}.
See also its methods (\code{summary.flipscores}, \code{anova.flipscores}, \code{print.flipscores}).
}
\description{
Provides robust tests for testing in GLMs, by sign-flipping score contributions. The tests are often robust against overdispersion, heteroscedasticity and, in some cases, ignored nuisance variables.
}
\details{
\code{flipscores} borrows the same parameters from function \code{glm} (and \code{glm.nb}). See these helps for more details about parameters such as \code{formula},
\code{data}, \code{family}. Note: in order to use Negative Binomial family, \code{family} reference must have quotes (i.e. \code{family="negbinom"}).
 Furthermore, \code{flipscores} object contains two extra elements: \code{scores}  -- i.e. a matrix of n score contributions, one column for each tested coefficient -- and \code{Tspace} -- i.e. a matrix of size \code{n_flips} times \code{ncol(scores)}. The fist row of  \code{Tspace} contains column-wise the test statistics generated by randomly flipping the score contributions, each column refers to the same column of \code{scores}, the vector of observed test statistics (i.e. no flips) is in the first row of \code{Tspace}.
}
\examples{
set.seed(1)
dt=data.frame(X=rnorm(20),
   Z=factor(rep(LETTERS[1:3],length.out=20)))
dt$Y=rpois(n=20,lambda=exp(dt$Z=="C"))
mod=flipscores(Y~Z+X,data=dt,family="poisson",n_flips=1000)
summary(mod)

# Equivalent to:
model=glm(Y~Z+X,data=dt,family="poisson")
mod2=flipscores(model)
summary(mod2)

}
\references{
"Robust testing in generalized linear models by sign-flipping score contributions" by J.Hemerik, J.Goeman and L.Finos.
}
\seealso{
\code{\link{anova.flipscores}}, \code{\link{summary.flipscores}}, \code{\link[flip]{flip}}
}
\author{
Livio Finos, Riccardo De Santis, Jesse Hemerik and Jelle Goeman
}
