% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{simulate_fmi_data}
\alias{simulate_fmi_data}
\title{Simulate FMI Data}
\usage{
simulate_fmi_data(
  N_A = 50,
  N_B = 50,
  T_points = 51,
  mean_shift = 0,
  scalar_shift = 0,
  eigenvalues = c(4, 1, 0.5, 0.1),
  noise_sd = 0.5,
  seed = NULL
)
}
\arguments{
\item{N_A}{Sample size for Group A (default: 50).}

\item{N_B}{Sample size for Group B (default: 50).}

\item{T_points}{Number of time points (default: 51).}

\item{mean_shift}{A shift added to FPC 1 scores for Group B (default: 0).}

\item{scalar_shift}{A shift added to the mean function for Group B (default: 0).}

\item{eigenvalues}{A vector of eigenvalues for FPCs (default: c(4, 1, 0.5, 0.1)).}

\item{noise_sd}{Standard deviation of measurement error (default: 0.5).}

\item{seed}{Optional. A random seed for reproducibility.}
}
\value{
A list with \code{Y_mat}, \code{group_vec}, and \code{argvals}.
}
\description{
Generates functional data for two groups with optional
differences in latent means or scalar intercepts.
}
\examples{
sim_data <- simulate_fmi_data(N_A = 10, N_B = 10, T_points = 20, seed = 123)
str(sim_data)
}
