% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{gen_hrf_lagged}
\alias{gen_hrf_lagged}
\alias{hrf_lagged}
\title{Generate a Lagged HRF Function}
\usage{
gen_hrf_lagged(hrf, lag = 2, normalize = FALSE, ...)

hrf_lagged(hrf, lag = 2, normalize = FALSE, ...)
}
\arguments{
\item{hrf}{A function representing the underlying HRF to be shifted.}

\item{lag}{A numeric value specifying the lag or delay in seconds to apply to the HRF. This can also be a vector of lags, in which case the function returns an HRF set.}

\item{normalize}{A logical value indicating whether to rescale the output so that the maximum absolute value is 1. Defaults to `FALSE`.}

\item{...}{Extra arguments supplied to the `hrf` function.}
}
\value{
A function representing the lagged HRF. If `lag` is a vector of lags, the function returns an HRF set.

an lagged hrf function
}
\description{
The `gen_hrf_lagged` function takes an HRF function and applies a specified lag to it. This can be useful for modeling time-delayed hemodynamic responses.
}
\section{Functions}{
\itemize{
\item \code{hrf_lagged()}: alias for gen_hrf_lagged

}}
\examples{
\donttest{
hrf_lag5 <- gen_hrf_lagged(HRF_SPMG1, lag=5)
hrf_lag5(0:20)
}

}
\seealso{
Other gen_hrf: 
\code{\link{gen_hrf_blocked}()}

Other gen_hrf: 
\code{\link{gen_hrf_blocked}()}
}
\concept{gen_hrf}
