% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_btdPosterior.R
\name{plot_btdPosterior}
\alias{plot_btdPosterior}
\title{Plot Posterior Distributions for \code{btdFoot} Objects}
\usage{
plot_btdPosterior(
  x,
  pars = "logStrength",
  plot_type = "boxplot",
  teams = NULL,
  ncol = NULL,
  scales = NULL
)
}
\arguments{
\item{x}{An object of class \code{btdFoot}.}

\item{pars}{A character string specifying the parameter to plot.
Choices are \code{"logStrength"}, \code{"logTie"}, and \code{"home"}.
Default is \code{"logStrength"}.}

\item{plot_type}{A character string specifying the type of plot.
Choices are \code{"boxplot"} and \code{"density"}.
Default is \code{"boxplot"}.}

\item{teams}{An optional character vector specifying team names to include in the posterior
boxplots or density plots. If \code{NULL}, all teams are included.}

\item{ncol}{An optional integer specifying the number of columns in the facet wrap
when using a dynamic Bayesian Bradley-Terry-Davidson model.
Default is \code{8}.}

\item{scales}{An optional character string specifying the scales for the facets
when using a dynamic Bayesian Bradley-Terry-Davidson model.
Options include \code{"free"}, \code{"fixed"}, \code{"free_x"}, and \code{"free_y"}.
Default is \code{"free_x"}.}
}
\value{
A \code{ggplot} object displaying:
\itemize{
  \item For \code{pars="logStrength"}:
    \itemize{
      \item Dynamic BTD: Faceted boxplots or density plots (including the 95\% credible interval) of posterior log-strengths by team and period.
      \item Static BTD: Boxplots or density plots (including the 95\% credible interval) of posterior log-strengths for each team.
    }
  \item For \code{pars="logTie"} or \code{pars="home"}: A single boxplot or density plot with 95\% credible interval.
}
}
\description{
Plots for the posterior distributions of team log-strengths and other parameters with customizable plot types and facets.
}
\examples{
\dontrun{
if (instantiate::stan_cmdstan_exists()) {
  library(dplyr)

  # Load example data
  data("italy")

  # Prepare the data
  italy_2020_2021_rank <- italy \%>\%
    select(Season, home, visitor, hgoal, vgoal) \%>\%
    filter(Season \%in\% c("2020", "2021")) \%>\%
    mutate(match_outcome = case_when(
      hgoal > vgoal ~ 1, # Home team wins
      hgoal == vgoal ~ 2, # Draw
      hgoal < vgoal ~ 3 # Away team wins
    )) \%>\%
    mutate(periods = case_when(
      row_number() <= 190 ~ 1,
      row_number() <= 380 ~ 2,
      row_number() <= 570 ~ 3,
      TRUE ~ 4
    )) \%>\% # Assign periods based on match number
    select(periods,
      home_team = home,
      away_team = visitor, match_outcome
    )

  # Fit the Bayesian Bradley-Terry-Davidson model with dynamic ranking
  fit_rank_dyn <- btd_foot(
    data = italy_2020_2021_rank,
    dynamic_rank = TRUE,
    rank_measure = "median",
    iter_sampling = 1000,
    parallel_chains = 2,
    chains = 2
  )

  # Plot posterior distributions with default settings
  plot_btdPosterior(fit_rank_dyn)

  # Plot posterior distributions for specific teams with customized facets
  plot_btdPosterior(
    fit_rank_dyn,
    teams = c("AC Milan", "AS Roma", "Juventus", "Inter"),
    ncol = 2
  )

  plot_btdPosterior(
    fit_rank_dyn,
    plot_type = "density",
    teams = c("AC Milan", "AS Roma", "Juventus", "Inter"),
    ncol = 2
  )
}
}
}
\author{
Roberto Macrì Demartino \email{roberto.macridemartino@deams.units.it}.
}
