% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_taxonomy.R
\name{select_taxonomy}
\alias{select_taxonomy}
\title{Select a taxonomy in FORCIS data}
\usage{
select_taxonomy(data, taxonomy)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}

\item{taxonomy}{a \code{character} of length 1. One among \code{"LT"}, \code{"VT"}, \code{"OT"}.}
}
\value{
A \code{tibble}.
}
\description{
Selects a taxonomy in FORCIS data. FORCIS database provides three different
taxonomies: \code{"LT"} (lumped taxonomy), \code{"VT"} (validated taxonomy) and \code{"OT"}
(original taxonomy). See \doi{10.1038/s41597-023-02264-2} for further
information.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Dimensions of the data.frame ----
dim(net_data)

# Select a taxonomy ----
net_data <- select_taxonomy(net_data, taxonomy = "VT")

# Dimensions of the data.frame ----
dim(net_data)
}
