% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_surface.R
\name{surface_to_triangles}
\alias{surface_to_triangles}
\title{Convert Freesurfer Surface to Triangles}
\usage{
surface_to_triangles(infile, ...)
}
\arguments{
\item{infile}{Input surface file}

\item{...}{additional arguments to pass to 
\code{\link{convert_surface}}}
}
\value{
Matrix of triangles with the number of rows equal
to the number of faces (not the triplets - total faces)
}
\description{
Reads in a surface file from Freesurfer and 
converts it into triangles
}
\examples{
if (have_fs()) {
infile = file.path(fs_subj_dir(), 
                   "bert", "surf", "rh.pial")
right_triangles = surface_to_triangles(infile = infile)
infile = file.path(fs_subj_dir(), 
                   "bert", "surf", "lh.pial")
left_triangles = surface_to_triangles(infile = infile) 
if (requireNamespace("rgl", quietly = TRUE)) {
  rgl::open3d()
  rgl::triangles3d(right_triangles, 
  color = rainbow(nrow(right_triangles)))
  rgl::triangles3d(left_triangles, 
  color = rainbow(nrow(left_triangles)))
}
infile = file.path(fs_subj_dir(), 
                   "bert", "surf", "rh.inflated")
right_triangles = surface_to_triangles(infile = infile)  
infile = file.path(fs_subj_dir(), 
                   "bert", "surf", "lh.inflated") 
left_triangles = surface_to_triangles(infile = infile)  
if (requireNamespace("rgl", quietly = TRUE)) {
  rgl::open3d()
  rgl::triangles3d(left_triangles, 
  color = rainbow(nrow(left_triangles)))
  rgl::triangles3d(right_triangles, 
  color = rainbow(nrow(right_triangles)))   
} 
}
}
