% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti_common.R
\name{nifti.datadim.from.dimfield}
\alias{nifti.datadim.from.dimfield}
\title{Compute data dimensions from the 'dim' field of the NIFTI (v1 or v2) header.}
\usage{
nifti.datadim.from.dimfield(dimfield)
}
\arguments{
\item{dimfield}{integer vector of length 8, the `dim` field of a NIFTI v1 or v2 header, as returned by \code{\link{read.nifti2.header}} or \code{\link{read.nifti1.header}}.}
}
\value{
integer vector of length <= 7. The lengths of the used data dimensions. The 'dim' field always has length 8, and the first entry is the number of actually used dimensions. The return value is constructed by stripping the first field and returning the used fields.
}
\description{
Compute data dimensions from the 'dim' field of the NIFTI (v1 or v2) header.
}
\examples{
   nifti.datadim.from.dimfield(c(3, 256, 256, 256, 1, 1, 1, 1));

}
\seealso{
Other NIFTI helper functions: 
\code{\link{nifti.datadim.to.dimfield}()}
}
\concept{NIFTI helper functions}
