% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_label.R
\name{read.fs.label.gii}
\alias{read.fs.label.gii}
\title{Read a label from a GIFTI label/annotation file.}
\usage{
read.fs.label.gii(filepath, label_value = 1L, element_index = 1L)
}
\arguments{
\item{filepath}{string. Full path to the input label file.}

\item{label_value}{integer, the label value of interest to extract from the annotation: the indices of the vertices with this value will be returned. See the note for details.. It is important to set this correctly, otherwise you may accidently load the vertices which are *not* part of the label.}

\item{element_index}{positive integer, the index of the data array to return. Ignored unless the file contains several data arrays.}
}
\value{
integer vector,  the vertex indices of the label
}
\description{
Read a label from a GIFTI label/annotation file.
}
\note{
A GIFTI label is more like a FreeSurfer annotation, as it assigns a label integer (region code) to each vertex of the surface instead of listing only the set of 'positive' vertex indices. If you are not sure about the contents of the label file, it is recommended to read it with \code{\link[freesurferformats]{read.fs.annot.gii}} instead. The `read.fs.label.gii` function only extracts one of the regions from the annotation as a label, while \code{\link[freesurferformats]{read.fs.annot.gii}} reads the whole annotation and gives you access to the label table, which should assign region names to each region, making it clearer which 'label_value' you want.
}
\seealso{
Other label functions: 
\code{\link{read.fs.label}()},
\code{\link{read.fs.label.native}()},
\code{\link{write.fs.label}()}

Other gifti readers: 
\code{\link{read.fs.annot.gii}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.surface.gii}()}
}
\concept{gifti readers}
\concept{label functions}
