% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_surface.R
\name{read.fs.surface.off}
\alias{read.fs.surface.off}
\title{Read Object File Format (OFF) mesh as surface.}
\usage{
read.fs.surface.off(filepath)
}
\arguments{
\item{filepath}{string. Full path to the input surface file in OFF mesh format.}
}
\value{
named list. The list has the following named entries: "vertices": nx3 double matrix, where n is the number of vertices. Each row contains the x,y,z coordinates of a single vertex. "faces": nx3 integer matrix. Each row contains the vertex indices of the 3 vertices defining the face. WARNING: The indices are returned starting with index 1 (as used in GNU R). Keep in mind that you need to adjust the index (by substracting 1) to compare with data from other software.
}
\description{
This reads meshes from text files in OFF mesh format. This is an ASCII format.
}
\seealso{
Other mesh functions: 
\code{\link{faces.quad.to.tris}()},
\code{\link{read.fs.surface}()},
\code{\link{read.fs.surface.asc}()},
\code{\link{read.fs.surface.bvsrf}()},
\code{\link{read.fs.surface.geo}()},
\code{\link{read.fs.surface.gii}()},
\code{\link{read.fs.surface.ico}()},
\code{\link{read.fs.surface.obj}()},
\code{\link{read.fs.surface.ply}()},
\code{\link{read.fs.surface.vtk}()},
\code{\link{read.mesh.brainvoyager}()},
\code{\link{read_nisurface}()},
\code{\link{read_nisurfacefile}()},
\code{\link{write.fs.surface}()},
\code{\link{write.fs.surface.asc}()},
\code{\link{write.fs.surface.byu}()},
\code{\link{write.fs.surface.gii}()},
\code{\link{write.fs.surface.mz3}()},
\code{\link{write.fs.surface.vtk}()}
}
\concept{mesh functions}
