% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{use_googlefont}
\alias{use_googlefont}
\title{Use online Google font in Shiny application}
\usage{
use_googlefont(family)
}
\arguments{
\item{family}{Name of the family to use, see \url{https://fonts.google.com}.}
}
\value{
a HTML tag to be included in a UI definition
}
\description{
Use online Google font in Shiny application
}
\examples{
if (interactive()) {
  library(shiny)
  library(fresh)

  ui <- fluidPage(

    use_googlefont("Saira Stencil One"),
    use_theme(create_theme(
      theme = "default",
      bs_vars_font(
        family_sans_serif = "'Saira Stencil One', cursive"
      )
    )),

    tags$h1("Use a google font (online demo)"),
    fluidRow(
      column(
        width = 6,
        tags$h2("Second level title"),
        tags$h3("Third level title"),
        tags$h4("Fourth level title"),
        tags$h5("Fifth level title"),
        tags$h6("Sixth level title"),
        tags$b("Bold text"),
        tags$p(
          "Lorem ipsum dolor sit amet, consectetur adipiscing elit,",
          " sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.",
          "Ut enim ad minim veniam, quis nostrud exercitation ullamco",
          " laboris nisi ut aliquip ex ea commodo consequat.",
          "Duis aute irure dolor in reprehenderit in voluptate velit",
          " esse cillum dolore eu fugiat nulla pariatur.",
          "Excepteur sint occaecat cupidatat non proident, sunt in",
          " culpa qui officia deserunt mollit anim id est laborum."
        )
      ),
      column(
        width = 6,
        textInput("caption", "Caption", "Data Summary"),
        actionButton("goButton", "Go!"),
        checkboxGroupInput("variable", "Variables to show:",
                           c("Cylinders" = "cyl",
                             "Transmission" = "am",
                             "Gears" = "gear")),
        selectInput("variable", "Variable:",
                    c("Cylinders" = "cyl",
                      "Transmission" = "am",
                      "Gears" = "gear"))
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
