% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_difference.R
\name{relative_difference}
\alias{relative_difference}
\title{Compute Relative Differences Between the Values of Two Vectors}
\usage{
relative_difference(
  current,
  reference,
  type = c("all.equal", "difference", "change", "change2")
)
}
\arguments{
\item{current}{One vector.}

\item{reference}{Another vector, for \code{type = all.equal}, this is passed
as \code{target}, for \code{type = all.equal} this can be thought of as the
"correct" value or the state "before".}

\item{type}{The method to be used. See Details.}
}
\value{
A vector of relative differences.
}
\description{
We often try to compare vectors on near equality. This is a wrapper to
\code{\link{all.equal}} for our convenience. It also implements relative
difference and change as discussed in
\url{https://en.wikipedia.org/wiki/Relative_change_and_difference}.
}
\details{
The default method (\code{type = all.equal}) applies
\code{\link{all.equal}} onto the two
vectors. Method \code{type = difference} is somewhat the same as the default,
method \code{type = change} takes account of the sign of the differences.
}
\examples{
n <- 500
x <- rnorm(n)
y <- x + rnorm(n, sd = 0.0001)
plot(relative_difference(x, y), x)
plot(relative_difference(x, y, "difference"), x)
# They do approximately the same:
max(relative_difference(relative_difference(x, y),
                            relative_difference(x, y, "difference")))
# But "all.equal" is _much_ slower:
microbenchmark::microbenchmark(all_equal = relative_difference(x, y),
                               difference = relative_difference(x, y,
                                                                "difference")
                               )
# Takes sign into account:
plot(relative_difference(x, y, "change"), x)
max(relative_difference(relative_difference(x, y),
                        abs(relative_difference(x, y, "change"))))
}
\seealso{
Other statistics: 
\code{\link{column_sums}()},
\code{\link{count_groups}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{sloboda}()},
\code{\link{weighted_variance}()}

Other vector comparing functions: 
\code{\link{compare_vectors}()}
}
\concept{statistics}
\concept{vector comparing functions}
