% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_fdcompute.R
\name{fw_fdcompute}
\alias{fw_fdcompute}
\title{Compute the functional diversity indices and community weighted means.}
\usage{
fw_fdcompute(
  fwdata,
  sitesdata,
  species,
  sites = NULL,
  dist = 1000,
  abund = NULL,
  FD = TRUE,
  dummy = TRUE
)
}
\arguments{
\item{fwdata}{\code{list} A list from the \code{fw_fetchdata} function is the only data type accepted.}

\item{sitesdata}{\code{dataframe} Dataframe with sites for which functional diversity and
community weighted means indices will be computed for.}

\item{species}{\code{string} The species column in the sitesdata.}

\item{sites}{\code{string} The sites column in the sitesdata. If the sites are not provided by the geometry column, then
sites can be auto generated by clustering closely separated records into sites.}

\item{dist}{\code{integer} The distance used to cluster points as sites. The default is 1000.}

\item{abund}{\code{string} Column with abundance data. If not provided, then only functional richness can be computed.}

\item{FD}{\code{logical} To indicate whether to compute functional richness or community weighted means. The default is TRUE.}

\item{dummy}{\code{logical} To form fuzzy code for the categorical traits. Default is TRUE.}
}
\value{
dataframe
}
\description{
Compute the functional diversity indices and community weighted means.
}
\examples{

\dontrun{

set.seed(1135)
data('speciesdata')
speciesdata$abundance <- rnorm(n = nrow(speciesdata), 4.3, 1.2)

spgeo1 <- speciesdata |>
 sf::st_as_sf(coords = c('decimalLongitude', 'decimalLatitude'), crs = sf::st_crs(4326))

sptraits <- fw_fetchdata(data = speciesdata,
                        ecoparams = c('rheophily habitat', 'spawning habitat',
                                      'feeding diet adult'),
                        taxonomic_column = 'scientificName',
                        organismgroup = 'fi')
#functional richness
testdata5 <- fw_fdcompute(fwdata = sptraits,
                         sitesdata = speciesdata,
                         sites = 'waterBody',
                         species = 'scientificName',
                         FD = TRUE)

}

}
