% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_distr.R
\name{distr_density}
\alias{distr_density}
\title{Compute Density}
\usage{
distr_density(y, f, distr, param = NULL, par_link = NULL, trans = NULL)
}
\arguments{
\item{y}{Observations. For an univariate distribution, a numeric vector. For a multivariate distribution, a numeric matrix with observations in rows or a numeric vector of a single observation.}

\item{f}{Parameters. For the same parameters for all observations, a numeric vector. For individual parameters for each observation, a numeric matrix with rows corresponding to observations.}

\item{distr}{A distribution.}

\item{param}{A parametrization of the distribution.}

\item{par_link}{An optional logical vector indicating whether the logarithmic/logistic link should be applied to restricted parameters in order to obtain unrestricted values. Defaults to keeping the original link for all parameters.}

\item{trans}{An optional transformation of the density. The supported transformation is the logarithm of the density (\code{trans = "log"}).}
}
\value{
The (transformed) density.
}
\description{
A function computing density or its logarithm of a given distribution.
}
\examples{
# Density of the negative binomial distribution
distr_density(y = c(1, 8, 5, 0, 0), f = c(13.50, 0.03), distr = "negbin")

}
\seealso{
\code{\link[gasmodel:distr]{distr()}}
}
