% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcite_citation_index.R
\name{gcite_citation_index}
\alias{gcite_citation_index}
\alias{gcite_citation_index.xml_node}
\alias{gcite_citation_index.xml_document}
\alias{gcite_citation_index.character}
\title{Parse Google Citation Index}
\usage{
gcite_citation_index(doc, ...)

\method{gcite_citation_index}{xml_node}(doc, ...)

\method{gcite_citation_index}{xml_document}(doc, ...)

\method{gcite_citation_index}{character}(doc, ...)
}
\arguments{
\item{doc}{A xml_document or the url for the main page}

\item{...}{Additional arguments passed to \code{\link[httr]{GET}} if 
\code{doc} is a URL}
}
\value{
A matrix of indices
}
\description{
Parses a google citation indices (h-index, etc.) from main page
}
\examples{
library(httr)
library(rvest) 
library(gcite)
url = "https://scholar.google.com/citations?user=T9eqZgMAAAAJ"
url = gcite_url(url = url, pagesize = 10, cstart = 0) 
if (!is_travis() & !is_cran()) {
ind = gcite_citation_index(url)
doc = content(httr::GET(url))
ind = gcite_citation_index(doc)
ind_nodes = rvest::html_nodes(doc, "#gsc_rsb_st")[[1]]
ind = gcite_citation_index(ind_nodes)
}
}
