% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{push_error_handler}
\alias{push_error_handler}
\title{Push a new GDAL CPLError handler}
\usage{
push_error_handler(handler)
}
\arguments{
\item{handler}{Character name of the error handler to push.
One of \code{quiet}, \code{logging} or \code{default}.}
}
\value{
No return value, called for side effects.
}
\description{
\code{push_error_handler()} is a wrapper for
\code{CPLPushErrorHandler()} in the GDAL Common Portability
Library.
This pushes a new error handler on the thread-local error handler stack.
This handler will be used until removed with \code{pop_error_handler()}.
A typical use is to temporarily set \code{CPLQuietErrorHandler()} which doesn't
make any attempt to report passed error or warning messages, but will
process debug messages via \code{CPLDefaultErrorHandler}.
}
\note{
This function is for advanced use cases. It is intended for setting a
\emph{temporary} error handler in a limited segment of code. A global error
handler specific to the R environment is in use by default.

Setting \code{handler = "logging"} will use \code{CPLLoggingErrorHandler()}, error
handler that logs into the file defined by the \code{CPL_LOG} configuration
option. Be sure that option is set when using this error handler.

This only affects error reporting from GDAL.
}
\examples{
push_error_handler("quiet")
# ...
pop_error_handler()
}
\seealso{
\code{\link[=pop_error_handler]{pop_error_handler()}}
}
