% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{geo_estimate_down}
\alias{geo_estimate_down}
\title{Estimate Down Geography Levels}
\usage{
geo_estimate_down(from, to, wts, value, method = "center", epsg = 3857)
}
\arguments{
\item{from}{Larger geography level}

\item{to}{smaller geography level}

\item{wts}{numeric vector of length nrow(to). Defaults to 1. Typically population or VAP, as a weight to give each precinct.}

\item{value}{numeric vector of length nrow(from). Defaults to 1. Typically electoral outcomes, as a value to estimate down into blocks.}

\item{method}{string from center, centroid, point, or area for matching levels}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
numeric vector with each value split by weight
}
\description{
Simple method for estimating data down to a lower level. This is most often useful
for getting election data down from a precinct level to a block level in the case
that a state or other jurisdiction split precincts when creating districts. Geographic
partner to estimate_down.
}
\examples{
library(dplyr)
set.seed(1)
data(checkerboard)
counties <- checkerboard |>
  group_by(id <= 32) |>
  summarize(geometry = sf::st_union(geometry)) |>
  mutate(pop = c(100, 200))
geo_estimate_down(from = counties, to = checkerboard, value = counties$pop)
}
\concept{estimate}
