% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOSampleDimension.R
\docType{class}
\name{ISOSampleDimension}
\alias{ISOSampleDimension}
\title{ISOSampleDimension}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISOSampleDimension
}
\description{
ISOSampleDimension

ISOSampleDimension
}
\examples{
\dontrun{
   setMetadataStandard("19115-3")
   #create band range dimension
   md <- ISOSampleDimension$new()
   md$setSequenceIdentifier(ISOMemberName$new(aName = "name", attributeType = "type"))
   md$setDescriptor("descriptor")
   md$setMaxValue(10)
   md$setMinValue(1)
   gml <- GMLBaseUnit$new(id = "ID")
   gml$setDescriptionReference("someref")
   gml$setIdentifier("identifier", "codespace")
   gml$addName("name1", "codespace")
   gml$addName("name2", "codespace")
   gml$setQuantityTypeReference("someref")
   gml$setCatalogSymbol("symbol")
   gml$setUnitsSystem("somelink")
   md$setUnits(gml)
   md$setScaleFactor(1)
   md$setOffset(4)
   xml <- md$encode()
   setMetadataStandard("19139")
 }

}
\references{
- ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mrc/1.0/mrc/#element_MD_SampleDimension}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{dimension}
\keyword{sample}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISORangeDimension]{geometa::ISORangeDimension}} -> \code{ISOSampleDimension}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{maxValue}}{maxValue [0..1] : numeric}

\item{\code{minValue}}{minValue [0..1] : numeric}

\item{\code{units}}{units [0..1] : GMLUnitDefinition}

\item{\code{scaleFactor}}{scaleFactor [0..1] : numeric}

\item{\code{offset}}{offset [0..1] : numeric}

\item{\code{meanValue}}{meanValue [0..1] : numeric (=> ISO 19115-3)}

\item{\code{numberOfValues}}{numberOfValues [0..1] : integer (=> ISO 19115-3)}

\item{\code{standardDeviation}}{standardDeviation [0..1]: numeric (=> ISO 19115-3)}

\item{\code{otherPropertyType}}{otherPropertyType [0..1] : ISORecordType (=> ISO 19115-3)}

\item{\code{otherProperty}}{otherProperty [0..1] : ISORecord (=> ISO 19115-3)}

\item{\code{bitsPerValue}}{bitsPerValue [0..1] : integer (=> ISO 19115-3)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOSampleDimension-new}{\code{ISOSampleDimension$new()}}
\item \href{#method-ISOSampleDimension-setMaxValue}{\code{ISOSampleDimension$setMaxValue()}}
\item \href{#method-ISOSampleDimension-setMinValue}{\code{ISOSampleDimension$setMinValue()}}
\item \href{#method-ISOSampleDimension-setUnits}{\code{ISOSampleDimension$setUnits()}}
\item \href{#method-ISOSampleDimension-setScaleFactor}{\code{ISOSampleDimension$setScaleFactor()}}
\item \href{#method-ISOSampleDimension-setOffset}{\code{ISOSampleDimension$setOffset()}}
\item \href{#method-ISOSampleDimension-setMeanValue}{\code{ISOSampleDimension$setMeanValue()}}
\item \href{#method-ISOSampleDimension-setNumberOfValues}{\code{ISOSampleDimension$setNumberOfValues()}}
\item \href{#method-ISOSampleDimension-setStandardDeviation}{\code{ISOSampleDimension$setStandardDeviation()}}
\item \href{#method-ISOSampleDimension-setOtherPropertyType}{\code{ISOSampleDimension$setOtherPropertyType()}}
\item \href{#method-ISOSampleDimension-setOtherProperty}{\code{ISOSampleDimension$setOtherProperty()}}
\item \href{#method-ISOSampleDimension-setBitsPerValue}{\code{ISOSampleDimension$setBitsPerValue()}}
\item \href{#method-ISOSampleDimension-clone}{\code{ISOSampleDimension$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setDescription"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setDescription'><code>geometa::ISORangeDimension$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setDescriptor"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setDescriptor'><code>geometa::ISORangeDimension$setDescriptor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setName"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setName'><code>geometa::ISORangeDimension$setName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setSequenceIdentifier"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setSequenceIdentifier'><code>geometa::ISORangeDimension$setSequenceIdentifier()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setMaxValue"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setMaxValue}{}}}
\subsection{Method \code{setMaxValue()}}{
Set max value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setMaxValue(maxValue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maxValue}}{max value, object of class \link{numeric}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setMinValue"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setMinValue}{}}}
\subsection{Method \code{setMinValue()}}{
Set min value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setMinValue(minValue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minValue}}{min value, object of class \link{numeric}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setUnits"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setUnits}{}}}
\subsection{Method \code{setUnits()}}{
Set unit definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setUnits(uom)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uom}}{object of class \link{GMLUnitDefinition}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setScaleFactor"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setScaleFactor}{}}}
\subsection{Method \code{setScaleFactor()}}{
Set scale factor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setScaleFactor(scaleFactor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scaleFactor}}{object of class \link{numeric}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setOffset"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setOffset}{}}}
\subsection{Method \code{setOffset()}}{
Set offset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setOffset(offset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{offset}}{object of class \link{numeric}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setMeanValue"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setMeanValue}{}}}
\subsection{Method \code{setMeanValue()}}{
Set mean value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setMeanValue(meanValue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{meanValue}}{meanValue object of class \link{numeric}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setNumberOfValues"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setNumberOfValues}{}}}
\subsection{Method \code{setNumberOfValues()}}{
Set number of values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setNumberOfValues(numberOfValues)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numberOfValues}}{numberOfValues object of class \link{integer}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setStandardDeviation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setStandardDeviation}{}}}
\subsection{Method \code{setStandardDeviation()}}{
Set standard deviation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setStandardDeviation(standardDeviation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{standardDeviation}}{standardDeviation object of class \link{numeric}$}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setOtherPropertyType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setOtherPropertyType}{}}}
\subsection{Method \code{setOtherPropertyType()}}{
setOtherPropertyType
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setOtherPropertyType(otherPropertyType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{otherPropertyType}}{otherPropertyType object of class \link{ISORecordType}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setOtherProperty"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setOtherProperty}{}}}
\subsection{Method \code{setOtherProperty()}}{
setOtherProperty
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setOtherProperty(otherProperty)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{otherProperty}}{otherProperty object of class \link{ISORecord}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-setBitsPerValue"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-setBitsPerValue}{}}}
\subsection{Method \code{setBitsPerValue()}}{
Set bits per value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$setBitsPerValue(bitsPerValue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bitsPerValue}}{bitsPerValue object of class \link{integer}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSampleDimension-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSampleDimension-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSampleDimension$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
