% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readmulti.tps.R
\name{readmulti.tps}
\alias{readmulti.tps}
\title{Read and combine multiple tps files}
\usage{
readmulti.tps(filelist, ...)
}
\arguments{
\item{filelist}{A vector containing the file paths to all the tps files to be compiled}

\item{...}{other arguments to be passed to \code{\link{readland.tps}}}
}
\value{
Function returns a (p x k x n) array, where p is the number of landmark points, k is the number 
  of landmark dimensions (2 or 3), and n is the total number of specimens across all tps files included in the folder read.
}
\description{
Read multiple tps files to obtain landmark coordinates and combine them into a single array
}
\details{
This is a wrapper of \code{\link{readland.tps}} to allow reading landmark coordinates, in 2D or 3D, from several tps files , and compiling them into an array for proceeding with GM procedures.

The arguments specID and negNA of \code{\link{readland.tps}} can be directly set through this function.
}
\author{
Antigoni Kaliontzopoulou

Michael Collyer
}
