% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNManager.R
\docType{class}
\name{GNManager}
\alias{GNManager}
\title{GeoNetwork REST API Manager}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for communication with
the API of a GeoNetwork instance.
}
\description{
The function \code{GNManager$new} will set-up the right Geonetwork
manager depending on the GeoNetwork version specified by the user. For the time-being,
GeoNetwork with version < 4 will be interfaced with the GeoNetwork legacy API (see detailed 
documentation at \link{GNLegacyAPIManager}), while starting with GeoNetwork 3.2, the new 
GeoNetwork OpenAPI will be used.
}
\examples{
\dontrun{
   GMManager$new("http://localhost:8080/geonetwork", "admin", "geonetwork", "3.0.0")
}


}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
\section{Super class}{
\code{\link[geonapi:GNAbstractManager]{geonapi::GNAbstractManager}} -> \code{GNManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GNManager-new}{\code{GNManager$new()}}
\item \href{#method-GNManager-clone}{\code{GNManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="ERROR"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-ERROR'><code>geonapi::GNAbstractManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="INFO"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-INFO'><code>geonapi::GNAbstractManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="WARN"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-WARN'><code>geonapi::GNAbstractManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getClassName"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-getClassName'><code>geonapi::GNAbstractManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getLang"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-getLang'><code>geonapi::GNAbstractManager$getLang()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getUrl"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-getUrl'><code>geonapi::GNAbstractManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="logger"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-logger'><code>geonapi::GNAbstractManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="login"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-login'><code>geonapi::GNAbstractManager$login()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-GNManager-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{GNManager}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNManager$new(url, user = NULL, pwd = NULL, version, logger = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{version}}{version}

\item{\code{logger}}{logger}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GNManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
