% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_ramp.R
\name{scale_colour_ramp}
\alias{scale_colour_ramp}
\alias{scale_colour_ramp_continuous}
\alias{scale_color_ramp}
\alias{scale_fill_ramp}
\alias{scale_color_ramp_continuous}
\alias{scale_colour_ramp_discrete}
\alias{scale_color_ramp_discrete}
\alias{scale_fill_ramp_continuous}
\alias{scale_fill_ramp_discrete}
\title{Secondary color scale that ramps from another color (ggplot2 scale)}
\usage{
scale_colour_ramp_continuous(
  from = "white",
  ...,
  limits = function(l) c(min(0, l[[1]]), l[[2]]),
  range = c(0, 1),
  guide = "legend",
  aesthetics = "colour_ramp"
)

scale_color_ramp_continuous(
  from = "white",
  ...,
  limits = function(l) c(min(0, l[[1]]), l[[2]]),
  range = c(0, 1),
  guide = "legend",
  aesthetics = "colour_ramp"
)

scale_colour_ramp_discrete(
  from = "white",
  ...,
  range = c(0.2, 1),
  aesthetics = "colour_ramp"
)

scale_color_ramp_discrete(
  from = "white",
  ...,
  range = c(0.2, 1),
  aesthetics = "colour_ramp"
)

scale_fill_ramp_continuous(..., aesthetics = "fill_ramp")

scale_fill_ramp_discrete(..., aesthetics = "fill_ramp")
}
\arguments{
\item{from}{<\link[=character]{string}> The color to ramp from. Corresponds to \code{0} on the scale.}

\item{...}{Arguments passed to underlying scale or guide functions. E.g.
\code{\link[=scale_colour_ramp_discrete]{scale_colour_ramp_discrete()}} passes arguments to \code{\link[ggplot2:discrete_scale]{discrete_scale()}},
\code{\link[=scale_colour_ramp_continuous]{scale_colour_ramp_continuous()}} passes arguments to \code{\link[ggplot2:continuous_scale]{continuous_scale()}}.
See those functions for more details.}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{range}{<length-2 \link{numeric}> Minimum and maximum
values after the scale transformation. These values should be between \code{0}
(the \code{from} color) and \code{1} (the color determined by the \code{fill} aesthetic).}

\item{guide}{<\link[ggplot2:ggplot2-ggproto]{Guide} | \link[=character]{string}> A function used to create a guide or its name. For
\code{\link[=scale_colour_ramp_continuous]{scale_colour_ramp_continuous()}} and \code{\link[=scale_fill_ramp_continuous]{scale_fill_ramp_continuous()}},
\code{\link[=guide_rampbar]{guide_rampbar()}} can be used to create gradient color bars. See
\code{\link[ggplot2:guides]{guides()}} for information on other guides.}

\item{aesthetics}{<\link{character}> Names of aesthetics to set scales for.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} representing a scale for the \code{colour_ramp} and/or \code{fill_ramp}
aesthetics for \code{ggdist} geoms. Can be added to a \code{\link[ggplot2:ggplot]{ggplot()}} object.
}
\description{
This scale creates a secondary scale that modifies the \code{fill} or \code{color} scale of
geoms that support it (\code{\link[=geom_lineribbon]{geom_lineribbon()}} and \code{\link[=geom_slabinterval]{geom_slabinterval()}}) to "ramp"
from a secondary color (by default white) to the primary fill color (determined
by the standard \code{color} or \code{fill} aesthetics). It uses the
\code{\link[=partial_colour_ramp]{partial_colour_ramp()}} data type.
}
\details{
These scales transform data into \code{\link{partial_colour_ramp}}s. Each \code{\link{partial_colour_ramp}}
is a pair of two values: a \code{from} colour and a numeric \code{amount} between \code{0}
and \code{1} representing a distance between \code{from} and the target color (where \code{0}
indicates the \code{from} color and \code{1} the target color).

The target color is determined by the corresponding aesthetic: for example,
the \code{colour_ramp} aesthetic creates ramps between \code{from} and whatever the
value of the \code{colour} aesthetic is; the \code{fill_ramp} aesthetic creates ramps
between \code{from} and whatever the value of the \code{fill} aesthetic is. When the
\code{colour_ramp} aesthetic is set, \pkg{ggdist} geometries will modify their
\code{colour} by applying the colour ramp between \code{from} and \code{colour} (and
similarly for \code{fill_ramp} and \code{fill}).

Colour ramps can be applied (i.e. translated into colours) using
\code{\link[=ramp_colours]{ramp_colours()}}, which can be used with \code{\link[=partial_colour_ramp]{partial_colour_ramp()}}
to implement geoms that make use of \code{colour_ramp} or \code{fill_ramp} scales.
}
\examples{

library(dplyr)
library(ggplot2)
library(distributional)

tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = after_stat(x)))

tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = after_stat(x)), fill = "blue") +
  scale_fill_ramp_continuous(from = "red")

# you can invert the order of `range` to change the order of the blend
tibble(d = dist_normal(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = after_stat(cut_cdf_qi(cdf))), fill = "blue") +
  scale_fill_ramp_discrete(from = "red", range = c(1, 0))

}
\seealso{
Other ggdist scales: 
\code{\link{scale_side_mirrored}()},
\code{\link{scale_thickness}},
\code{\link{sub-geometry-scales}}

Other colour ramp functions: 
\code{\link{guide_rampbar}()},
\code{\link{partial_colour_ramp}()},
\code{\link{ramp_colours}()}
}
\author{
Matthew Kay
}
\concept{colour ramp functions}
\concept{ggdist scales}
