% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{smooth_discrete}
\alias{smooth_discrete}
\alias{smooth_bar}
\title{Smooth dot positions in a dotplot of discrete values ("bar dotplots")}
\usage{
smooth_discrete(
  x,
  kernel = c("rectangular", "gaussian", "epanechnikov", "triangular", "biweight",
    "cosine", "optcosine"),
  width = 0.7,
  ...
)

smooth_bar(x, width = 0.7, ...)
}
\arguments{
\item{x}{<\link{numeric}> Values to smooth.}

\item{kernel}{<\link[=character]{string}> The smoothing kernel to be used. This must partially
match one of \code{"gaussian"}, \code{"rectangular"}, \code{"triangular"}, \code{"epanechnikov"},
\code{"biweight"}, \code{"cosine"}, or \code{"optcosine"}. See \code{\link[stats:density]{stats::density()}}.}

\item{width}{<scalar \link{numeric}> approximate width of the bars as a fraction
of data \code{\link[ggplot2:resolution]{resolution()}}.}

\item{...}{additional parameters; \code{\link[=smooth_discrete]{smooth_discrete()}} passes these to
\code{\link[=smooth_unbounded]{smooth_unbounded()}} and thereby to \code{\link[=density_unbounded]{density_unbounded()}}; \code{\link[=smooth_bar]{smooth_bar()}}
ignores them.}
}
\value{
A numeric vector of \code{length(x)}, where each entry is a smoothed version of
the corresponding entry in \code{x}.

If \code{x} is missing, returns a partial application of itself. See \link{automatic-partial-functions}.
}
\description{
\strong{Note:} Better-looking bar dotplots are typically easier to achieve using
\code{layout = "bar"} with the \code{\link[=geom_dotsinterval]{geom_dotsinterval()}} family instead of
\code{smooth = "bar"} or \code{smooth = "discrete"}.

Smooths \code{x} values where \code{x} is presumed to be discrete, returning a new \code{x}
of the same length. Both \code{smooth_discrete()} and \code{smooth_bar()} use the
\code{\link[ggplot2:resolution]{resolution()}} of the data to apply smoothing around unique values in the
dataset; \code{smooth_discrete()} uses a kernel density estimator and \code{smooth_bar()}
places values in an evenly-spaced grid. Can be used with a dotplot
(e.g. \code{\link{geom_dots}}\code{(smooth = ...)}) to create "bar dotplots".

Supports \link[=auto_partial]{automatic partial function application} with
\link[=waiver]{waived arguments}.
}
\details{
\code{smooth_discrete()} applies a kernel density estimator (default: rectangular)
to \code{x}. It automatically sets the bandwidth to be such that the kernel's
width (for each kernel type) is approximately \code{width} times the \code{\link[ggplot2:resolution]{resolution()}}
of the data. This means it essentially creates smoothed bins around each
unique value. It calls down to \code{\link[=smooth_unbounded]{smooth_unbounded()}}.

\code{smooth_bar()} generates an evenly-spaced grid of values spanning \verb{+/- width/2}
around each unique value in \code{x}.
}
\examples{

library(ggplot2)

set.seed(1234)
x = rpois(1000, 2)

# automatic binwidth in basic dotplot on large counts in discrete
# distributions is very small
ggplot(data.frame(x), aes(x)) +
  geom_dots()

# NOTE: It is now recommended to use layout = "bar" instead of
# smooth = "discrete" or smooth = "bar"; the latter are retained because
# they can sometimes be useful in combination with other layouts for
# more specialized (but finicky) applications.
ggplot(data.frame(x), aes(x)) +
  geom_dots(layout = "bar")

# smooth_discrete() constructs wider bins of dots
ggplot(data.frame(x), aes(x)) +
  geom_dots(smooth = "discrete")

# smooth_bar() is an alternative approach to rectangular layouts
ggplot(data.frame(x), aes(x)) +
  geom_dots(smooth = "bar")

# adjust the shape by changing the kernel or the width. epanechnikov
# works well with side = "both"
ggplot(data.frame(x), aes(x)) +
  geom_dots(smooth = smooth_discrete(kernel = "epanechnikov", width = 0.8), side = "both")


}
\seealso{
Other dotplot smooths: 
\code{\link{smooth_density}},
\code{\link{smooth_none}()}
}
\concept{dotplot smooths}
