% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_pnames}
\alias{get_pnames}
\title{Get Free Parameter Names from Model}
\usage{
get_pnames(model_r, debug = FALSE)
}
\arguments{
\item{model_r}{An S4 object containing the model specification and design}

\item{debug}{Logical flag indicating whether to print debugging information
about both free and fixed parameters (default: FALSE)}
}
\value{
A character vector of free parameter names in the model
}
\description{
Extracts the names of free parameters from an S4 model object, with optional
debugging output to inspect both free and constant parameters.
}
\details{
The function:
\enumerate{
  \item Creates a new design object from the model
  \item Optionally prints debugging information about all parameters
  \item Returns only the names of free (non-constant) parameters
}
}
\section{Debugging Output}{

When `debug = TRUE`, the function prints:
\itemize{
  \item Free parameters (those being estimated)
  \item Constants (fixed parameters)
}
}

\examples{
model <- BuildModel(
  p_map = list(A = "1", B = "1", mean_v = "M", sd_v = "1", st0 = "1",
               t0 = "1"),
  match_map = list(M = list(s1 = "r1", s2 = "r2")),
  factors = list(S = c("s1", "s2")),
  constants = c(A = 0.75, mean_v.false = 1.5, sd_v = 1, st0 = 0),
  accumulators = c("r1", "r2"),
  type = "lba")

pnames <- get_pnames(model)

}
