% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow.R
\name{with_shadow}
\alias{with_shadow}
\title{Apply a drop shadow to a layer}
\usage{
with_shadow(
  x,
  colour = "black",
  x_offset = 10,
  y_offset = 10,
  sigma = 1,
  stack = TRUE,
  ...
)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{colour}{The colour of the shadow}

\item{x_offset, y_offset}{The offset of the shadow from the origin
as numerics}

\item{sigma}{The standard deviation of the gaussian kernel. Increase it to
apply more blurring. If a numeric it will be interpreted as given in pixels.
If a unit object it will automatically be converted to pixels at rendering
time}

\item{stack}{Should the original layer be placed on top?}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter applies the familiar drop-shadow effect on elements in a layer.
It takes the outline of each shape, offsets it from its origin and applies a
blur to it.
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(mpg, disp)) +
  with_shadow(geom_point(colour = 'red', size = 3), sigma = 3)

}
