% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-sf-pixel.R
\docType{data}
\name{StatPixel}
\alias{StatPixel}
\alias{geom_sf_pixel}
\title{Generate pixel maps on sf objects}
\format{
An object of class \code{StatPixel} (inherits from \code{StatSf}, \code{Stat}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
StatPixel

geom_sf_pixel(
  mapping = NULL,
  data = NULL,
  n = 40,
  distribution = "uniform",
  seed = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}.
\code{v1} and \code{v2} are required, which are the variables used as the parameters
in the sampling distribution.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{n}{integer of length 1 or 2, number of grid cells in x and y direction (columns, rows)}

\item{distribution}{Sampling distribution: \code{"uniform"}(the default) or, \code{"normal"}.
\itemize{
\item \code{"uniform"} treats \code{v1} as the centre and uniformly samples within the range
\verb{(v1 - v2, v1 + v2)}.
\item \code{"normal"} treats \code{v1} as the mean and \code{v2} as the standard deviation.
}}

\item{seed}{Random seed used to ensure reproducibility of the sampling process.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.

You can also set this to one of "polygon", "line", and "point" to
override the default legend.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}
}
\value{
A list of ggplot2 layer objects.
}
\description{
\code{geom_sf_pixel()} adds a pixel map layer based on simple feature (sf) objects
to a ggplot. In a pixel map, each region is divided into small pixels, with
colours mapped from values sampled from distribution specified.
}
\section{Pixel map layer contents}{

The layer returned by \code{geom_sf_pixel()} internally includes a scale object
created by \code{scale_fill_distiller()}.
Therefore, modifying the scale will trigger a message indicating that
the scale for \code{fill} is being replaced.
}

\examples{
# Basic pixel map
p <- ggplot(nc) + geom_sf_pixel(mapping = aes(v1 = value, v2 = sd), n = 20)

# Replacing the internal fill scale triggers a message
# ("Scale for fill is already present. Adding another scale for fill...")
p + scale_fill_distiller(palette = "Blues")

}
\keyword{datasets}
