% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_phy.R
\name{read_phy}
\alias{read_phy}
\title{Process PhyloSuite RSCU Data for Visualization}
\usage{
read_phy(folder_path)
}
\arguments{
\item{folder_path}{Path to folder containing CSV files. Files must contain:
- 'RSCU' column
- Species-reflecting file names
- Required columns: AA, Codon, Fill, RSCU}
}
\value{
Visualization-ready data frame with:
\describe{
  \item{AA}{Amino acid code}
  \item{Codon}{RNA triplet}
  \item{Fill}{Position index (1-6)}
  \item{Species}{Organism identifier}
  \item{RSCU}{Normalized usage values}
}
}
\description{
Processes Relative Synonymous Codon Usage (RSCU) data from PhyloSuite CSV files,
preparing it for visualization with the `ggmRSCU` package.
}
\details{
Performs:
\itemize{
  \item File validation for required structure
  \item Species name extraction
  \item Data reshaping to long format
  \item NA removal
}
}
\examples{
# Using example data
example_dir <- system.file("extdata", "phy", package = "ggmRSCU")
result <- read_phy(example_dir)
head(result)

}
