% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rscu_data}
\alias{rscu_data}
\title{Relative Synonymous Codon Usage (RSCU) Data}
\format{
A tibble with 186 rows and 5 columns:
\describe{
  \item{AA}{\code{character} Standard three-letter amino acid code with
            isotype variants indicating synonymous codon groups: e.g.,
            \code{"Phe"}, \code{"Leu1"}, \code{"Leu2"}}
  \item{Codon}{\code{character} RNA codon triplet in uppercase:
              e.g., \code{"UUU"}, \code{"CUA"}}
  \item{Fill}{\code{integer} Group index classifying synonymous codons
             for each amino acid (e.g., 1, 2, etc.)}
  \item{Species}{\code{character} Organism identifier in
                \code{[Accession].[Version]} format: e.g.,
                \code{"MK693137.1"}}
  \item{RSCU}{\code{numeric} Relative Synonymous Codon Usage value}
}
}
\source{
Data derived from previously published studies based on protein-
coding sequences analyzed in our laboratory. Accession numbers correspond
to NCBI GenBank.
}
\usage{
data(rscu_data)
}
\description{
A longitudinal dataset documenting codon usage bias patterns across
multiple species. Contains normalized RSCU values calculated from protein-
coding sequences.
}
\keyword{datasets}
