% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-table.R
\name{ttheme_gtdefault}
\alias{ttheme_gtdefault}
\alias{ttheme_gtminimal}
\alias{ttheme_gtbw}
\alias{ttheme_gtplain}
\alias{ttheme_gtdark}
\alias{ttheme_gtlight}
\alias{ttheme_gtsimple}
\alias{ttheme_gtstripes}
\title{Table themes}
\usage{
ttheme_gtdefault(
  base_size = 10,
  base_colour = "black",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(0.8, 0.6), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)

ttheme_gtminimal(
  base_size = 10,
  base_colour = "black",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(0.5, 0.4), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)

ttheme_gtbw(
  base_size = 10,
  base_colour = "black",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(1, 0.6), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)

ttheme_gtplain(
  base_size = 10,
  base_colour = "black",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(0.8, 0.6), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)

ttheme_gtdark(
  base_size = 10,
  base_colour = "grey90",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(0.8, 0.6), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)

ttheme_gtlight(
  base_size = 10,
  base_colour = "grey10",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(0.8, 0.6), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)

ttheme_gtsimple(
  base_size = 10,
  base_colour = "grey10",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(0.5, 0.4), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)

ttheme_gtstripes(
  base_size = 10,
  base_colour = "grey10",
  base_family = "",
  parse = FALSE,
  padding = grid::unit(c(0.8, 0.6), "char"),
  text.alpha = NA,
  rules.alpha = NA,
  canvas.alpha = NA,
  ...
)
}
\arguments{
\item{base_size}{numeric, default font size of text in table.}

\item{base_colour}{default font colour for text in table.}

\item{base_family}{default font family for text in table.}

\item{parse}{logical, behaviour for parsing text as plotmath.}

\item{padding}{length-2 unit vector specifying the horizontal and vertical
padding of text within each cell.}

\item{text.alpha, canvas.alpha, rules.alpha}{numeric in [0..1] Transparency
applied to table \code{base_colour}, to table body background
\code{fill} and rules \code{colour}, respectively.}

\item{...}{further arguments to control the gtable.}
}
\value{
A \code{list} object that can be used as \code{ttheme} in the
  construction of tables with functions from package 'gridExtra'.
}
\description{
Additional theme constructors for use with \code{\link{geom_table}}.
}
\details{
These wrapper functions are table theme (\code{ttheme}) constructors
  making it easier to change the style of tables created with
  \code{\link[gridExtra]{tableGrob}}. When passed as argument to
  \code{\link{geom_table}} the table theme's \code{base_colour},
  \code{base_family}, \code{base_colour} and \code{base_size} function as
  defaults for the text in the body of the table. They are overriden if the
  corresponding text-related aesthetics are mapped or set to a constant
  through the usual 'ggplot2' mechanisms. On the other hand the properties
  of the background fill, rules and column and row headings can be set only
  through the theme. The \code{ttheme} constructors defined in
  'ggpp' have formal parameters for \code{alpha} transparency of the
  text, background and rules. Transparency is useful as plot insets can
  accidentally overlap observations hiding them from view depending on the
  stacking order of plot layers.

  These theme constructors are wrappers on the constructors
  \code{gridExtra::ttheme_default()} and \code{gridExtra::ttheme_minimal()}.
  They can also be used directly with \code{\link[gridExtra]{grid.table}} if
  desired.
}
\examples{
library(dplyr)
library(tibble)

mtcars |>
  group_by(cyl) |>
  summarize(wt = mean(wt), mpg = mean(mpg)) |>
  ungroup() |>
  mutate(wt = sprintf("\%.2f", wt),
         mpg = sprintf("\%.1f", mpg)) -> tb

df <- tibble(x = 5.45, y = 34, tb = list(tb))

# Same as the default theme constructor
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtdefault) +
  theme_classic()

# Minimal theme constructor
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtminimal) +
  theme_classic()

# A theme with white background
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtbw) +
  theme_bw()

# Base colour of theme overridden by aesthetic constant
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtbw, colour = "darkblue") +
  theme_bw()

# A theme with dark background
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtdark) +
  theme_dark()

# Base colour of theme overridden by aesthetic constant
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtdark, colour = "yellow") +
  theme_dark()

# A theme with light background
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtlight)

# Base colour of theme overridden by aesthetic constant
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtlight, colour = "darkred")

# Base colour of theme overridden by aesthetic constant
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtsimple)

# Default colour of theme superceded by aesthetic constant
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb),
             table.theme = ttheme_gtstripes) +
  theme_dark()

# Transparency of table background fill and grid lines colour
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = 1.5, y = y, label = tb),
             table.theme = ttheme_gtplain(canvas.alpha = 0.5,
                                          rules.alpha = 0.2)) +
  theme_classic()

# Transparency of table background fill and grid lines colour
# and table text base colour: black with 50\% transparency
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = 1.5, y = y, label = tb),
             table.theme = ttheme_gtplain(text.alpha = 0.5)) +
  theme_classic()

}
\concept{geometries for adding insets to ggplots}
