% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-brain.R
\name{theme_brain}
\alias{theme_brain}
\alias{theme_darkbrain}
\alias{theme_custombrain}
\alias{theme_brain2}
\title{ggseg plot theme}
\usage{
theme_brain(text.size = 12, text.family = "mono")

theme_darkbrain(text.size = 12, text.family = "mono")

theme_custombrain(
  plot.background = "white",
  text.colour = "darkgrey",
  text.size = 12,
  text.family = "mono"
)

theme_brain2(
  plot.background = "white",
  text.colour = "darkgrey",
  text.size = 12,
  text.family = "mono"
)
}
\arguments{
\item{text.size}{Specify size of plot text}

\item{text.family}{Specify font family}

\item{plot.background}{Specify fill of plot background (`theme_custombrain` only)}

\item{text.colour}{Specify colour of plot text}
}
\value{
function that alters the themeing of a ggplot object
}
\description{
a set of themes created for the ggseg plots. Use theme() to tweak.
}
\details{
\describe{

\item{`theme_brain`}{
Default theme for ggseg. Transparent background, no axis lines, and no grid.}

\item{`theme_darkbrain`}{
Dark equivalent to theme_brain, with black background, and light text.}

\item{`theme_custombrain`}{
Theme for easy customization of the brain themes.}

}
}
\examples{
library(ggplot2)

p <- ggplot() +
  geom_brain(atlas = dk)

p +
  theme_brain()

p +
  theme_darkbrain()

}
\seealso{
[ggplot()], [aes()], [geom_polygon()], [coord_fixed()] from the ggplot2 package
}
\author{
Athanasia Mo Mowinckel
}
