% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_annotations.R
\name{draw_annotations}
\alias{draw_annotations}
\title{Draw Text Annotations to a ggplot Object}
\usage{
draw_annotations(annotations_data, zoom_level = 1)
}
\arguments{
\item{annotations_data}{A data frame containing annotation information. Typically, this comes from a CSV file generated by the ggsem Shiny app. The required columns include:
\itemize{
  \item \code{text}: The text to annotate (character).
  \item \code{x}, \code{y}: The coordinates for the text (numeric).
  \item \code{font}: The font family to use (character, e.g., "serif").
  \item \code{size}: The size of the text (numeric).
  \item \code{color}: The color of the text (character, valid hex color).
  \item \code{angle}: The rotation angle of the text (numeric, in degrees).
  \item \code{alpha}: The transparency of the text (numeric, 0 to 1).
  \item \code{fontface}: The font style (character, e.g., "bold").
  \item \code{math_expression}: Logical, whether the text should be parsed as a mathematical expression.
}}

\item{zoom_level}{Numeric. Adjusts the size of annotations based on the zoom level. Default is \code{1}.}
}
\value{
ggplot2 annotation layers
}
\description{
This function overlays text annotations onto any ggplot object. It is particularly useful for adding annotations from CSV files generated by the ggsem Shiny app but can also be used with custom annotation data.
}
\examples{
library(ggplot2)

annotations_data <- data.frame(
text = 'x1', x = 9.5, y = 21, font = 'sans',
size = 16, color = '#FFFFFF', fill = NA, angle = 0,
alpha = 1, fontface = 'plain', math_expression = FALSE,
lavaan = FALSE, network = FALSE, locked = FALSE,
group_label = FALSE, loop_label = FALSE, group = 1
)

p <- ggplot()

p + draw_annotations(annotations_data, zoom_level = 1.2)
}
