% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_fig.R
\name{save_figure}
\alias{save_figure}
\title{Save a ggplot Object with Adjusted Dimensions}
\usage{
save_figure(
  filename,
  plot,
  units = "in",
  dpi = 300,
  aspect_ratio = NULL,
  scale_factor = 0.122,
  zoom_level = 1,
  ...
)
}
\arguments{
\item{filename}{A string. The name of the output file (e.g., "plot.png").}

\item{plot}{A ggplot object to save.}

\item{units}{A string. Units for width and height. Default is \code{"in"} (inches). Other options include \code{"cm"} or \code{"mm"}.}

\item{dpi}{Numeric. Resolution of the output file in dots per inch. Default is 300.}

\item{aspect_ratio}{Numeric or \code{NULL}. If provided, fixes the aspect ratio of the plot (e.g., \code{1} for square). If \code{NULL}, uses the natural data aspect ratio. Default is \code{NULL}.}

\item{scale_factor}{Numeric. A scaling factor to control the overall size of the saved plot. Default is \code{0.122}.}

\item{zoom_level}{Numeric. A zoom factor, value > 1 means zoom out. Default is \code{1.0}.}

\item{...}{Additional arguments passed to \code{ggsave()}.}
}
\value{
Saves the ggplot object to the specified file and does not return a value.
}
\description{
This function saves a ggplot object (created from 'csv_to_ggplot()' function) to a file with dimensions automatically determined based on
the x-axis and y-axis ranges of the plot. The size of the output can be further controlled using addtional arguments.
}
\examples{
\dontrun{
# CSV files from ggsem app
points_data <- data.frame(
x = 20, y = 20, shape = 'rectangle', color = '#D0C5ED', size = 50,
border_color = '#9646D4', border_width = 2, alpha = 1,
width_height_ratio = 1.6, orientation = 45, lavaan = FALSE,
network = FALSE, locked = FALSE, group = 1
)

lines_data <- data.frame(
x_start = 2, y_start = -2, x_end = 10, y_end = -2, ctrl_x = NA, ctrl_y = NA,
ctrl_x2 = NA, ctrl_y2 = NA, curvature_magnitude = NA, rotate_curvature = NA,
curvature_asymmetry = NA, type = 'Straight Line', color = '#000000',
end_color = NA, color_type = 'Single',
gradient_position = NA, width = 1.5, alpha = 1, arrow = FALSE,
arrow_type = NA, arrow_size = NA, two_way = FALSE, lavaan = FALSE,
network = FALSE, line_style = 'solid', locked = FALSE, group = 1
)

p1 <- csv_to_ggplot(graphics_data = list(points_data, lines_data),
              zoom_level = 1.2, # Value from the ggsem app
              horizontal_position = 0, # Value from the ggsem app
              element_order = c('lines', 'points')) # order priority: lines < points

# Save with default scaling
save_figure("p1.png", p1)
}
}
