% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statStudent.R
\name{geom_student}
\alias{geom_student}
\title{Student CI plot}
\usage{
geom_student(
  mapping = NULL,
  data = NULL,
  position = "identity",
  width = 0.25,
  type = "density",
  scale = TRUE,
  draw_lines = NULL,
  draw_mean = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings. See [ggplot2::layer()] for details.}

\item{data}{The data to be displayed in this layer. See [ggplot2::layer()] for details.}

\item{position}{A position adjustment to use on the data for this layer. See [ggplot2::layer()] for details.}

\item{width}{Scaling parameter for the width of the violin/rectangle.}

\item{type}{Type of the plot. The default is \code{"density"} which draws violin style density plot,
whereas \code{"box"} draws a rectangle shaped gradient plot.}

\item{scale}{If \code{"TRUE"} (default), violins/rectangles are scaled according
to the maximum width of the groups (\code{max(dt(0, df) / se)}).}

\item{draw_lines}{If not \code{NULL} (default), draw horizontal lines
at the given quantiles of the density estimate.}

\item{draw_mean}{If \code{TRUE} (default), draw horizontal line at mean.}

\item{show.legend}{logical. Should this layer be included in the legends? See [ggplot2::layer()] for details.}

\item{inherit.aes}{If `FALSE`, overrides the default aesthetics. See [ggplot2::layer()] for details.}

\item{...}{Other arguments passed to [ggplot2::layer()], such as fixed aesthetics.}
}
\value{
A ggplot object.
}
\description{
A Student CI plot (or Violin CI plot) is a mirrored density plot similar to violin plot
but instead of kernel density estimate it is based on the density of the t-distribution.
It can be though of as a continuous "confidence interval density" (hence the name),
which could reduce the dichotomous interpretations due to a fixed confidence level.
\code{geom_student} can also be used to draw Gradient CI plots (using argument \code{type}),
which replaces the violin shaped density with a rectangle.
}
\examples{
library("dplyr")
library("ggplot2")
library("scales")

ci_levels <- c(0.999, 0.95, 0.9, 0.8, 0.5)
n <- length(ci_levels)
ci_levels <- factor(ci_levels, levels = ci_levels)
PlantGrowth \%>\% dplyr::group_by(group) \%>\%
  dplyr::summarise(
    mean = mean(weight),
    df = dplyr::n() - 1,
    se = sd(weight)/sqrt(df + 1)) \%>\%
 dplyr::full_join(
   data.frame(group =
     rep(levels(PlantGrowth$group), each = n),
     level = ci_levels), by = "group") -> d

p <- ggplot(data = d, aes(group)) +
 geom_student(aes(mean = mean, se = se, df = df,
   level = level, fill = level), draw_lines = c(0.95, 0.5))
p
g <- scales::seq_gradient_pal("#e5f5f9", "#2ca25f")
p + scale_fill_manual(values=g(seq(0,1,length = n))) + theme_bw()

p2 <- ggplot(data = d, aes(group)) +
 geom_student(aes(mean = mean, se = se, df = df,
   level = level, fill = level), type = "box", draw_lines = c(0.95, 0.5))
p2

}
\references{
Helske, J., Helske, S., Cooper, M., Ynnerman, A., & Besancon, L. (2021).
Can visualization alleviate dichotomous thinking? Effects of visual representations on the cliff effect.
IEEE Transactions on Visualization and Computer Graphics, 27(8), 3397-3409 doi: 10.1109/TVCG.2021.3073466
}
